/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.incoming;

import com.mulesoft.modules.wss.api.incoming.IncomingWss;
import java.util.concurrent.TimeUnit;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.TimestampProcessor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class VerifyTimestampConfig
implements IncomingWss {
    @Parameter
    @Summary(value="The time within which the Timestamp element is valid. The default is 5 minutes.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="300")
    private Integer timeToLive;
    @Parameter
    @Summary(value="The time difference between server and client. The default is 60 seconds.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="60")
    private Integer skewTime;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Summary(value="Time unit to be used in the timeToLive configuration")
    private TimeUnit timeUnit;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="Strict")
    private boolean isStrict;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean requireExpiresHeader;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean precisionInMilliseconds;

    @Override
    public void setUp(WSSConfig wssConfig, RequestData data) {
        data.setTimeStampTTL((int)this.timeUnit.convert(this.timeToLive.intValue(), TimeUnit.SECONDS));
        data.setTimeStampStrict(this.isStrict);
        data.setTimeStampFutureTTL((int)this.timeUnit.convert(this.skewTime.intValue(), TimeUnit.SECONDS));
        data.setRequireTimestampExpires(this.requireExpiresHeader);
        data.setPrecisionInMilliSeconds(this.precisionInMilliseconds);
        wssConfig.setProcessor(WSConstants.TIMESTAMP, TimestampProcessor.class);
    }
}

