/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.outgoing;

import com.mulesoft.modules.wss.api.MessagePart;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.WssException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

abstract class BaseOutgoingConfig {
    @Parameter
    @Optional
    @DisplayName(value="Parts")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Lists of parts to be encrypted. If any part is specified the SOAP Body will be encrypted.")
    private List<MessagePart> wssParts;

    BaseOutgoingConfig() {
    }

    protected List<WSEncryptionPart> createWSParts() {
        if (this.wssParts == null) {
            return new ArrayList<WSEncryptionPart>();
        }
        return this.wssParts.stream().map(p -> new WSEncryptionPart(p.getLocalname(), p.getNamespace(), p.getEncode().toString())).collect(Collectors.toList());
    }

    protected Crypto getCrypto(KeyStoreConfiguration keyStoreConfiguration) {
        try {
            return new Merlin(keyStoreConfiguration.getWssProperties(), this.getClass().getClassLoader(), null);
        }
        catch (Exception e) {
            throw new WssException("Could not create crypto for keystore: " + keyStoreConfiguration.getPath(), e);
        }
    }
}

