/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.outgoing;

import com.mulesoft.modules.wss.api.constants.EncryptionDigestAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionKeyIdentifierConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionKeyTransportAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionSymAlgorithmConstants;
import com.mulesoft.modules.wss.api.outgoing.BaseOutgoingConfig;
import com.mulesoft.modules.wss.api.outgoing.OutgoingWss;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.WssApplyException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.xml.security.Init;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.w3c.dom.Document;

public class EncryptionConfig
extends BaseOutgoingConfig
implements OutgoingWss {
    @Parameter
    @Optional(defaultValue="ISSUER_SERIAL")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The key identifier type to use for encryption.")
    private EncryptionKeyIdentifierConstants encryptionKeyIdentifier;
    @Parameter
    @Optional(defaultValue="AES_128")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The symmetric encryption algorithm to use.")
    private EncryptionSymAlgorithmConstants encryptionSymAlgorithm;
    @Parameter
    @Optional(defaultValue="KEYTRANSPORT_RSAOAEP")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The algorithm to use to encrypt the generated symmetric key.")
    private EncryptionKeyTransportAlgorithmConstants encryptionKeyTransportAlgorithm;
    @Parameter
    @Optional(defaultValue="SHA1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The encryption digest algorithm to use with the key transport algorithm.")
    private EncryptionDigestAlgorithmConstants encryptionDigestAlgorithm;
    @Parameter
    @Optional
    @DisplayName(value="KeyStore Configuration")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="keystore-config")
    private KeyStoreConfiguration keyStoreConfiguration;
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager runtimeObjectStoreManager;

    @Override
    public void apply(String correlationId, Document envelope, WSSecHeader securityHeader) throws WssApplyException {
        try {
            Init.init();
            WSSecEncrypt wsEncrypt = new WSSecEncrypt(securityHeader);
            if (this.keyStoreConfiguration == null) {
                X509Certificate signReqCertificate = this.getSigningRequestCertificate(correlationId);
                if (signReqCertificate != null) {
                    wsEncrypt.setUseThisCert(signReqCertificate);
                }
            } else {
                wsEncrypt.setUserInfo(this.keyStoreConfiguration.getAlias(), this.keyStoreConfiguration.getKeyPassword());
            }
            wsEncrypt.setSymmetricEncAlgorithm(this.encryptionSymAlgorithm.toString());
            wsEncrypt.setKeyEncAlgo(this.encryptionKeyTransportAlgorithm.toString());
            wsEncrypt.setDigestAlgorithm(this.encryptionDigestAlgorithm.toString());
            List<WSEncryptionPart> wsParts = this.createWSParts();
            if (!wsParts.isEmpty()) {
                wsEncrypt.getParts().addAll(wsParts);
            }
            wsEncrypt.build(this.keyStoreConfiguration != null ? this.getCrypto(this.keyStoreConfiguration) : null);
        }
        catch (Exception e) {
            throw new WssApplyException(e);
        }
    }

    private X509Certificate getSigningRequestCertificate(String correlationId) {
        ObjectStore defaultPartition = this.runtimeObjectStoreManager.getDefaultPartition();
        try {
            return (X509Certificate)defaultPartition.retrieve(correlationId);
        }
        catch (ObjectStoreException e) {
            return null;
        }
    }
}

