/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.outgoing;

import com.mulesoft.modules.wss.api.constants.SignatureAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureC14nAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureDigestAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureKeyIdentifierConstants;
import com.mulesoft.modules.wss.api.outgoing.BaseOutgoingConfig;
import com.mulesoft.modules.wss.api.outgoing.OutgoingWss;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.WssApplyException;
import com.mulesoft.modules.wss.internal.error.WssSecurityException;
import java.util.List;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.w3c.dom.Document;

public class SignatureConfig
extends BaseOutgoingConfig
implements OutgoingWss {
    @Parameter
    @Optional(defaultValue="ISSUER_SERIAL")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The key identifier type to use for signature.")
    private SignatureKeyIdentifierConstants keyIdentifier;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The signature algorithm to use. The default is set by the data in the certificate.")
    private SignatureAlgorithmConstants algorithm;
    @Parameter
    @Optional(defaultValue="SHA1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The signature digest algorithm to use.")
    private SignatureDigestAlgorithmConstants digestAlgorithm;
    @Parameter
    @Optional(defaultValue="ExclusiveXMLCanonicalization_1_0")
    @DisplayName(value="Signature c14n algorithm")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Defines which signature c14n (canonicalization) algorithm to use.")
    private SignatureC14nAlgorithmConstants c14nAlgorithm;
    @Parameter
    @DisplayName(value="KeyStore Configuration")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="keystore-config")
    private KeyStoreConfiguration keyStoreConfiguration;

    @Override
    public void apply(String correlationId, Document envelope, WSSecHeader header) throws WssApplyException {
        try {
            List<WSEncryptionPart> wsParts;
            WSSecSignature wssSign = new WSSecSignature(header);
            wssSign.setUserInfo(this.keyStoreConfiguration.getAlias(), this.keyStoreConfiguration.getKeyPassword());
            if (this.keyIdentifier != null) {
                wssSign.setKeyIdentifierType(this.keyIdentifier.getNumVal());
            }
            if (this.algorithm != null) {
                wssSign.setSignatureAlgorithm(this.algorithm.toString());
            }
            if (this.c14nAlgorithm != null) {
                wssSign.setSigCanonicalization(this.c14nAlgorithm.toString());
            }
            if (this.digestAlgorithm != null) {
                wssSign.setDigestAlgo(this.digestAlgorithm.toString());
            }
            if (!(wsParts = this.createWSParts()).isEmpty()) {
                wssSign.getParts().addAll(wsParts);
            }
            wssSign.build(this.getCrypto(this.keyStoreConfiguration));
        }
        catch (Exception e) {
            throw new WssSecurityException("Could not sign Envelope: " + e.getMessage(), e);
        }
    }
}

