/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.store;

import java.util.Properties;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@TypeDsl(allowTopLevelDefinition=true)
public class KeyStoreConfiguration {
    @Parameter
    @Placement(order=0)
    @Summary(value="The location of the store file.")
    @Path(type=PathModel.Type.FILE, location=PathModel.Location.EMBEDDED)
    private String path;
    @Parameter
    @Placement(order=1)
    @Summary(value="The password to access the store.")
    @Password
    private String password;
    @Parameter
    @Placement(order=2)
    @Summary(value="The alias of the private key to use")
    @Optional
    private String alias;
    @Parameter
    @Placement(order=3)
    @Summary(value="The password used to access the private key.")
    @Optional
    @Password
    private String keyPassword;
    @Parameter
    @Optional(defaultValue="jks")
    @Placement(order=4)
    @Summary(value="The type of store (jks, pkcs12, jceks, or any other)")
    private String type;

    public String getPath() {
        return this.path;
    }

    public String getPassword() {
        return this.password;
    }

    public String getType() {
        return this.type;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getAlias() {
        return this.alias;
    }

    public Properties getWssProperties() {
        Properties properties = new Properties();
        properties.put("org.apache.wss4j.crypto.merlin.keystore.file", this.path);
        if (this.type != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.type", this.type);
        }
        if (this.password != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.password", this.password);
        }
        if (this.alias != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.alias", this.alias);
        }
        if (this.keyPassword != null) {
            properties.put("org.apache.wss4j.crypto.merlin.keystore.private.password", this.keyPassword);
        }
        return properties;
    }
}

