/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.incoming;

import com.mulesoft.modules.wss.api.SoapVersion;
import com.mulesoft.modules.wss.api.auth.MustUnderstandAuthentication;
import com.mulesoft.modules.wss.internal.error.WssErrorTypeProvider;
import com.mulesoft.modules.wss.internal.error.WssException;
import com.mulesoft.modules.wss.internal.error.WssSecurityException;
import com.mulesoft.modules.wss.internal.incoming.WssIncomingConfig;
import com.mulesoft.modules.wss.internal.util.SoapMessageHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.soap.SOAPMessage;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WssIncomingOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(WssIncomingOperations.class);
    private static final SoapMessageHandler ENVELOPE_DOCUMENT_FACTORY = new SoapMessageHandler();
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager runtimeObjectStoreManager;

    @Throws(value={WssErrorTypeProvider.class})
    @MediaType(value="application/xml", strict=false)
    @DisplayName(value="Process WSS")
    public Result<InputStream, Void> process(@Config WssIncomingConfig config, @Content TypedValue<InputStream> request, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SOAP_11") SoapVersion version, CorrelationInfo correlationInfo, AuthenticationHandler handler) {
        try {
            this.setMustUnderstand(handler);
            String contentType = request.getDataType().getMediaType().toRfcString();
            SOAPMessage soapMessage = ENVELOPE_DOCUMENT_FACTORY.create((InputStream)request.getValue(), contentType, version);
            Document envelope = soapMessage.getSOAPPart().getDocumentElement().getOwnerDocument();
            Element header = WSSecurityUtil.findWsseSecurityHeaderBlock((Document)envelope, (Element)envelope.getDocumentElement(), (String)config.getActor(), (boolean)false);
            if (header == null) {
                throw new WssSecurityException("Missing wsse:Security header in request");
            }
            WSHandlerResult result = config.processSecurity(envelope);
            this.saveSigningCert(correlationInfo.getCorrelationId(), result);
            if (config.extractSecurityHeader()) {
                new WSSecHeader(config.getActor(), envelope).removeSecurityHeader();
            }
            return Result.builder().output((Object)ENVELOPE_DOCUMENT_FACTORY.serialize(soapMessage)).mediaType(org.mule.runtime.api.metadata.MediaType.parse((String)contentType)).build();
        }
        catch (WssException | WSSecurityException e) {
            throw new WssSecurityException("Error trying to process message security", (Exception)e);
        }
    }

    private void saveSigningCert(String correlationId, WSHandlerResult result) {
        List wsSecEngineResults = result.getResults();
        ObjectStore defaultPartition = this.runtimeObjectStoreManager.getDefaultPartition();
        for (WSSecurityEngineResult wser : wsSecEngineResults) {
            Integer wserAction = (Integer)wser.get((Object)"action");
            if (wserAction == null || wserAction != 2) continue;
            X509Certificate cert = (X509Certificate)wser.get((Object)"x509-certificate");
            try {
                defaultPartition.store(correlationId, (Serializable)cert);
            }
            catch (ObjectStoreException e) {
                LOGGER.warn("Unable to store signing certificate for future encryption");
            }
            return;
        }
    }

    private void setMustUnderstand(AuthenticationHandler handler) {
        if (handler == null) {
            return;
        }
        Optional authenticationOption = handler.getAuthentication();
        if (authenticationOption.isPresent()) {
            Authentication authentication = (Authentication)authenticationOption.get();
            HashMap<String, Object> newProps = new HashMap<String, Object>(authentication.getProperties());
            newProps.putAll(new MustUnderstandAuthentication().getProperties());
            authentication.setProperties(newProps);
        } else {
            try {
                handler.setAuthentication((Authentication)new MustUnderstandAuthentication());
            }
            catch (SecurityException | SecurityProviderNotFoundException | UnknownAuthenticationTypeException e) {
                throw new WssException("Cannot set Must Understand Authentication", (Exception)e);
            }
        }
    }
}

