/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.outgoing;

import com.mulesoft.modules.wss.api.SoapVersion;
import com.mulesoft.modules.wss.api.outgoing.EncryptionConfig;
import com.mulesoft.modules.wss.api.outgoing.SignatureConfig;
import com.mulesoft.modules.wss.internal.error.WssApplyException;
import com.mulesoft.modules.wss.internal.error.WssErrorTypeProvider;
import com.mulesoft.modules.wss.internal.outgoing.WssOutgoingConfig;
import com.mulesoft.modules.wss.internal.util.SoapMessageHandler;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.soap.SOAPMessage;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.w3c.dom.Document;

public class WssOutgoingOperations {
    private static final SoapMessageHandler ENVELOPE_DOCUMENT_FACTORY = new SoapMessageHandler();
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager runtimeObjectStoreManager;

    @Throws(value={WssErrorTypeProvider.class})
    @MediaType(value="application/xml", strict=false)
    @DisplayName(value="Apply WSS")
    public Result<InputStream, Void> apply(@Config WssOutgoingConfig config, @Content TypedValue<InputStream> response, @Optional(defaultValue="SOAP_12") SoapVersion version, CorrelationInfo correlationInfo) {
        try {
            String contentType = response.getDataType().getMediaType().toRfcString();
            SOAPMessage soapMessage = ENVELOPE_DOCUMENT_FACTORY.create((InputStream)response.getValue(), contentType, version);
            Document envelope = soapMessage.getSOAPPart().getDocumentElement().getOwnerDocument();
            WSSecHeader securityHeader = new WSSecHeader(envelope);
            securityHeader.insertSecurityHeader();
            securityHeader.setMustUnderstand(config.getMustUnderstand());
            this.applyConfigs(config, correlationInfo.getCorrelationId(), envelope, securityHeader);
            InputStream result = ENVELOPE_DOCUMENT_FACTORY.serialize(soapMessage);
            return Result.builder().output((Object)result).mediaType(org.mule.runtime.api.metadata.MediaType.parse((String)contentType)).build();
        }
        catch (Exception e) {
            throw new WssApplyException(e);
        }
    }

    private void applyConfigs(WssOutgoingConfig config, String correlationId, Document envelope, WSSecHeader securityHeader) {
        SignatureConfig signatureConfig = config.getSignatureConfig();
        EncryptionConfig encryptionConfig = config.getEncryptionConfig();
        if (signatureConfig != null) {
            signatureConfig.apply(correlationId, envelope, securityHeader);
        }
        if (encryptionConfig != null) {
            encryptionConfig.apply(correlationId, envelope, securityHeader);
        }
        this.removeSigningRequestCertificate(correlationId);
    }

    private void removeSigningRequestCertificate(String correlationId) {
        ObjectStore defaultPartition = this.runtimeObjectStoreManager.getDefaultPartition();
        try {
            if (defaultPartition.contains(correlationId)) {
                defaultPartition.remove(correlationId);
            }
        }
        catch (ObjectStoreException e) {
            throw new WssApplyException(e);
        }
    }
}

