/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

import org.apache.wss4j.dom.WSConstants;

/**
 * Key Identifier Type to use for encryption.
 *
 * @since 1.0
 */
public enum EncryptionKeyIdentifierConstants {

  ISSUER_SERIAL("IssuerSerial", WSConstants.ISSUER_SERIAL), DIRECT_REFERENCE("DirectReference",
      WSConstants.BST_DIRECT_REFERENCE), X509_KEY_IDENTIFIER("X509KeyIdentifier", WSConstants.X509_KEY_IDENTIFIER), THUMBPRINT(
          "Thumbprint", WSConstants.THUMBPRINT_IDENTIFIER), SKI_KEY_IDENTIFIER("SKIKeyIdentifier",
              WSConstants.SKI_KEY_IDENTIFIER), ENCRYPTED_KEY_SHA1("EncryptedKeySHA1",
                  WSConstants.ENCRYPTED_KEY_SHA1_IDENTIFIER), EMBEDDED_KEY_NAME("EmbeddedKeyName", WSConstants.EMBEDDED_KEYNAME);

  private String name;
  private int value;

  EncryptionKeyIdentifierConstants(String name, int value) {
    this.name = name;
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public int getNumVal() {
    return value;
  }

  @Override
  public String toString() {
    return name;
  }
}
