/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

import org.apache.wss4j.common.saml.bean.Version;

import static org.apache.wss4j.common.saml.bean.Version.SAML_10;
import static org.apache.wss4j.common.saml.bean.Version.SAML_11;
import static org.apache.wss4j.common.saml.bean.Version.SAML_20;

/**
 * SAML Version.
 *
 * @since 1.0
 */
public enum SamlVersion {

  SAML10(SAML_10), SAML11(SAML_11), SAML20(SAML_20);

  private Version version;

  SamlVersion(Version version) {
    this.version = version;
  }

  public Version getVersion() {
    return version;
  }

}
