/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Signature Canonicalization Algorithm to be used for the signature c14n.
 * Listed on the <a href="https://www.w3.org/TR/xmldsig-core1/">W3C XML Signature specification</a>.
 *
 * @since 1.0
 */
public enum SignatureC14nAlgorithmConstants {

  CanonicalXML_1_0("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"), CanonicalXML_1_1(
      "http://www.w3.org/2006/12/xml-c14n11"), ExclusiveXMLCanonicalization_1_0("http://www.w3.org/2001/10/xml-exc-c14n#");


  private String value;

  SignatureC14nAlgorithmConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}
