/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

import org.apache.wss4j.dom.WSConstants;

/**
 * Signature Key Identifier Type.
 *
 * @since 1.0
 */
public enum SignatureKeyIdentifierConstants {

  ISSUER_SERIAL("IssuerSerial", WSConstants.ISSUER_SERIAL), DIRECT_REFERENCE("DirectReference",
      WSConstants.BST_DIRECT_REFERENCE), X509_KEY_IDENTIFIER("X509KeyIdentifier", WSConstants.X509_KEY_IDENTIFIER), THUMBPRINT(
          "Thumbprint", WSConstants.THUMBPRINT_IDENTIFIER), SKI_KEY_IDENTIFIER("SKIKeyIdentifier",
              WSConstants.SKI_KEY_IDENTIFIER), KEY_VALUE("KeyValue", WSConstants.KEY_VALUE);

  private String name;
  private final int numVal;

  SignatureKeyIdentifierConstants(String name, int numVal) {
    this.name = name;
    this.numVal = numVal;
  }

  @Override
  public String toString() {
    return name;
  }

  public int getNumVal() {
    return numVal;
  }
}
