/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Authentication configuration sub-type based on LDAP service.
 *
 * @since 1.0
 */
public class LDAPConfig implements AuthenticateUserConfig {

  /**
   * LDAP Server URL.
   */
  @Parameter
  @Summary("LDAP Server URL")
  private String providerUrl;

  /**
   * User that will authenticate to the directory.
   */
  @Parameter
  @Summary("User that will authenticate to the directory.")
  private String userDn;

  /**
   * Credentials to use for getting authenticated contexts.
   */
  @Parameter
  @Summary("Credentials to use for getting authenticated contexts.")
  private String password;

  /**
   * The search base defines the starting point for the search in the directory tree.
   */
  @Parameter
  @Summary("Starting point for the search in the directory tree.")
  private String searchBase;

  /**
   * Filters can be used to restrict the numbers of users or groups that are permitted to access an application.
   */
  @Parameter
  @Summary("Used to restrict the numbers of users or groups that are permitted to access an application.")
  private String searchFilter;

  /**
   * Whether to search in subtree.
   */
  @Parameter
  @Summary("Whether to search in subtree.")
  @Expression(NOT_SUPPORTED)
  private boolean searchInSubtree;

  public String getProviderUrl() {
    return providerUrl;
  }

  public String getUserDn() {
    return userDn;
  }

  public String getPassword() {
    return password;
  }

  public String getSearchBase() {
    return searchBase;
  }

  public String getSearchFilter() {
    return searchFilter;
  }

  public boolean isSearchInSubtree() {
    return searchInSubtree;
  }
}
