/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import com.mulesoft.modules.wss.api.store.TrustStoreConfiguration;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Signature related configuration used for verify them.
 *
 * @since 1.0
 */
public class VerifySignatureConfig {

  /**
   * TrustStore configuration used for validating the signature.
   */
  @Parameter
  @DisplayName("TrustStore Configuration")
  @Summary("TrustStore configuration used for validating the signature.")
  @Expression(NOT_SUPPORTED)
  @Alias("truststore-config")
  private TrustStoreConfiguration trustStoreConfig;

  /**
   * Certificate Issuer pattern.
   */
  @Parameter
  @Optional
  @Summary("Certificate Issuer pattern.")
  @Example("CN=Mulesoft.*")
  private String issuerPattern;

  /**
   * Certificate Subject pattern.
   */
  @Parameter
  @Optional
  @Summary("Certificate Subject pattern.")
  @Example("CN=Mulesoft.*")
  private String subjectPattern;

  public TrustStoreConfiguration getTrustStoreConfig() {
    return trustStoreConfig;
  }

  public String getIssuerPattern() {
    return issuerPattern;
  }

  public String getSubjectPattern() {
    return subjectPattern;
  }
}
