/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.concurrent.TimeUnit;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Timestamp configuration used to verify the freshness of a message.
 *
 * @since 1.0
 */
public class VerifyTimestampConfig {

  /**
   * The time within which the Timestamp element is valid. The default is 5 minutes.
   */
  @Parameter
  @Optional(defaultValue = "300")
  @Summary("The time within which the Timestamp element is valid. The default is 5 minutes.")
  @Expression(NOT_SUPPORTED)
  private Integer timeToLive;

  /**
   * The time difference between server and client. The default is 60 seconds.
   */
  @Parameter
  @Optional(defaultValue = "60")
  @Summary("The time difference between server and client. The default is 60 seconds.")
  @Expression(NOT_SUPPORTED)
  private Integer skewTime;

  /**
   * Time unit to be used in the timeToLive configuration.
   */
  @Parameter
  @Optional(defaultValue = "SECONDS")
  @Summary("Time unit to be used in the timeToLive configuration.")
  private TimeUnit timeUnit;

  /**
   * If set to true then validates if the timestamp contains an expires element and the semantics are expired.
   */
  @Parameter
  @Optional(defaultValue = "true")
  @Summary("If set to true then validates if the timestamp contains an expires element and the semantics are expired.")
  @Expression(NOT_SUPPORTED)
  @Alias("Strict")
  private boolean strict;

  /**
   * Whether timestamp Expires header is required.
   */
  @Parameter
  @Optional(defaultValue = "true")
  @Summary("Whether a timestamp Expires header is required.")
  @Expression(NOT_SUPPORTED)
  private boolean requireExpiresHeader;

  /**
   * If set to true then use timestamps with milliseconds, otherwise omit the milliseconds.
   */
  @Parameter
  @Optional(defaultValue = "true")
  @Summary("If set to true then use timestamps with milliseconds, otherwise omit the milliseconds.")
  @Expression(NOT_SUPPORTED)
  private boolean precisionInMilliseconds;

  public Integer getTimeToLive() {
    return timeToLive;
  }

  public Integer getSkewTime() {
    return skewTime;
  }

  public TimeUnit getTimeUnit() {
    return timeUnit;
  }

  public boolean isStrict() {
    return strict;
  }

  public boolean isRequireExpiresHeader() {
    return requireExpiresHeader;
  }

  public boolean isPrecisionInMilliseconds() {
    return precisionInMilliseconds;
  }
}
