/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Authentication configuration used for validating Username Token profile.
 *
 * @since 1.0
 */
public class VerifyUsernameTokenConfig {

  /**
   * Specific type for the authentication configuration. See {@link AuthenticateUserConfig} sub-types.
   */
  @Parameter
  @Summary("Specific type for the authentication configuration.")
  @Expression(NOT_SUPPORTED)
  @ParameterDsl(allowReferences = false)
  private AuthenticateUserConfig authenticateUserConfig;

  /**
   * The time difference between creation and expiry time in seconds in the UsernameToken Created element.
   */
  @Parameter
  @Optional(defaultValue = "30")
  @Summary("The time difference between creation and expiry time in seconds in the UsernameToken Created element.")
  @Expression(NOT_SUPPORTED)
  private Integer timeToLive;

  /**
   * Whether to check the Nonce Element in the UsernameToken.
   * A Nonce is a random value that the sender creates to include in each UsernameToken that it sends.
   * Only checked if included.
   */
  @Parameter
  @Optional(defaultValue = "true")
  @Summary("Whether to check the Nonce Element in the UsernameToken.")
  @Expression(NOT_SUPPORTED)
  private boolean checkNonce;

  public AuthenticateUserConfig getAuthenticateUserConfig() {
    return authenticateUserConfig;
  }

  public Integer getTimeToLive() {
    return timeToLive;
  }

  public boolean isCheckNonce() {
    return checkNonce;
  }
}
