/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.outbound;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.List;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Base outbound configuration.
 *
 * @since 1.0
 */
public abstract class BaseOutboundConfig {

  /**
   * Lists of parts to be encrypted. If any part is specified, the SOAP Body will be encrypted.
   */
  @Parameter
  @Optional
  @DisplayName("Parts")
  @Expression(NOT_SUPPORTED)
  @Summary("Lists of parts to be encrypted. If any part is specified, the SOAP Body will be encrypted.")
  private List<MessagePart> wssParts;

  public List<MessagePart> getWssParts() {
    return wssParts;
  }
}
