/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.outbound;

import com.mulesoft.modules.wss.api.constants.SignEncodeConstants;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Group which holds the data that identifies a part of a SOAP message to be signed or encrypted.
 *
 * @since 1.0
 */
@Alias("wss-part")
public class MessagePart {

  /**
   * Constant that indicates whether to sign an Element or a Content.
   * See {@link SignEncodeConstants}
   */
  @Parameter
  @Optional(defaultValue = "CONTENT")
  @Summary("Constant that indicates whether to sign an Element or a Content.")
  @Expression(NOT_SUPPORTED)
  private SignEncodeConstants encode;

  /**
   * Element namespace.
   */
  @Parameter
  @Summary("Element namespace.")
  @Expression(NOT_SUPPORTED)
  private String namespace;

  /**
   * Element localname.
   */
  @Parameter
  @Summary("Element localname.")
  @Expression(NOT_SUPPORTED)
  private String localname;


  public SignEncodeConstants getEncode() {
    return encode;
  }

  public String getNamespace() {
    return namespace;
  }

  public String getLocalname() {
    return localname;
  }

}
