/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.outbound;

import com.mulesoft.modules.wss.api.constants.SignatureAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureC14nAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureDigestAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.SignatureKeyIdentifierConstants;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Signature related configuration used for signing the message.
 *
 * @since 1.0
 */
public class SignatureConfig extends BaseOutboundConfig {

  /**
   * The key identifier type to use for signature.
   * See {@link SignatureKeyIdentifierConstants}
   */
  @Parameter
  @Optional(defaultValue = "ISSUER_SERIAL")
  @Summary("The key identifier type to use for signature.")
  @Expression(NOT_SUPPORTED)
  private SignatureKeyIdentifierConstants keyIdentifier;

  /**
   * The signature algorithm to use. The default is set by the data in the certificate.
   * See {@link SignatureAlgorithmConstants}
   */
  @Parameter
  @Optional
  @Summary("The signature algorithm to use. The default is set by the data in the certificate.")
  @Expression(NOT_SUPPORTED)
  private SignatureAlgorithmConstants algorithm;

  /**
   * The signature digest algorithm to use.
   * See {@link SignatureDigestAlgorithmConstants}
   */
  @Parameter
  @Optional(defaultValue = "SHA1")
  @Summary("The signature digest algorithm to use.")
  @Expression(NOT_SUPPORTED)
  private SignatureDigestAlgorithmConstants digestAlgorithm;

  /**
   * Defines which signature c14n (canonicalization) algorithm to use.
   * See {@link SignatureC14nAlgorithmConstants}
   */
  @Parameter
  @Optional(defaultValue = "ExclusiveXMLCanonicalization_1_0")
  @Summary("Defines which signature c14n (canonicalization) algorithm to use.")
  @DisplayName("Signature c14n algorithm")
  @Expression(NOT_SUPPORTED)
  private SignatureC14nAlgorithmConstants c14nAlgorithm;

  /**
   * KeyStore configuration used for signing.
   */
  @Parameter
  @DisplayName("KeyStore Configuration")
  @Summary("KeyStore configuration used for signing.")
  @Expression(NOT_SUPPORTED)
  @Alias("keystore-config")
  private KeyStoreConfiguration keyStoreConfiguration;

  public SignatureKeyIdentifierConstants getKeyIdentifier() {
    return keyIdentifier;
  }

  public SignatureAlgorithmConstants getAlgorithm() {
    return algorithm;
  }

  public SignatureDigestAlgorithmConstants getDigestAlgorithm() {
    return digestAlgorithm;
  }

  public SignatureC14nAlgorithmConstants getC14nAlgorithm() {
    return c14nAlgorithm;
  }

  public KeyStoreConfiguration getKeyStoreConfiguration() {
    return keyStoreConfiguration;
  }

}
