/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.store;

import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.model.display.PathModel.Location.EMBEDDED;
import static org.mule.runtime.api.meta.model.display.PathModel.Type.FILE;

/**
 * KeyStore configuration.
 *
 * @since 1.0
 */
@TypeDsl(allowTopLevelDefinition = true)
public class KeyStoreConfiguration {

  /**
   * The location of the store file.
   */
  @Parameter
  @Placement(order = 0)
  @Summary("The location of the store file.")
  @Path(type = FILE, location = EMBEDDED)
  private String path;

  /**
   * The password to access the store.
   */
  @Parameter
  @Placement(order = 1)
  @Summary("The password to access the store.")
  @Password
  private String password;

  /**
   * The alias of the private key to use.
   */
  @Parameter
  @Placement(order = 2)
  @Optional
  @Summary("The alias of the private key to use.")
  private String alias;

  /**
   * The password used to access the private key.
   */
  @Parameter
  @Placement(order = 3)
  @Optional
  @Summary("The password used to access the private key.")
  @Password
  private String keyPassword;

  /**
   * The type of store (jks, pkcs12, jceks, or any other).
   */
  @Parameter
  @Placement(order = 4)
  @Optional(defaultValue = "jks")
  @Summary("The type of store (jks, pkcs12, jceks, or any other).")
  private String type;

  public String getPath() {
    return path;
  }

  public String getPassword() {
    return password;
  }

  public String getType() {
    return type;
  }

  public String getKeyPassword() {
    return keyPassword;
  }

  public String getAlias() {
    return alias;
  }

}
