/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.error;

import com.mulesoft.modules.wss.internal.inbound.WssInboundOperations;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.Set;

import com.google.common.collect.ImmutableSet;

import static com.mulesoft.modules.wss.internal.error.WssError.*;

/**
 * {@link ErrorTypeProvider} implementation for the {@link WssInboundOperations}.
 *
 */
public class WssErrorTypeProvider implements ErrorTypeProvider {

  /**
   * @return all the error types that can be thrown by the {@link WssInboundOperations}.
   */
  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    return ImmutableSet.of(MISSING_CERTIFICATE, SECURITY_VALIDATING, SECURITY_APPLYING);
  }
}
