/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.handler;

import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.api.store.TrustStoreConfiguration;
import org.apache.wss4j.common.crypto.Merlin;

import java.util.Properties;

/**
 * Utility class for handling configuration cross operations.
 */
public class StoreConfigHandler {

  private StoreConfigHandler() {}

  protected static Properties getWssProperties(KeyStoreConfiguration keyStoreConfiguration) {
    Properties properties = new Properties();
    properties.put(Merlin.PREFIX + Merlin.KEYSTORE_FILE, keyStoreConfiguration.getPath());
    String type = keyStoreConfiguration.getType();
    if (type != null) {
      properties.put(Merlin.PREFIX + Merlin.KEYSTORE_TYPE, type);
    }
    String password = keyStoreConfiguration.getPassword();
    if (password != null) {
      properties.put(Merlin.PREFIX + Merlin.KEYSTORE_PASSWORD, password);
    }
    String alias = keyStoreConfiguration.getAlias();
    if (alias != null) {
      properties.put(Merlin.PREFIX + Merlin.KEYSTORE_ALIAS, alias);
    }
    String keyPassword = keyStoreConfiguration.getKeyPassword();
    if (keyPassword != null) {
      properties.put(Merlin.PREFIX + Merlin.KEYSTORE_PRIVATE_PASSWORD, keyPassword);
    }
    return properties;
  }

  protected static Properties getWssProperties(TrustStoreConfiguration trustStoreConfiguration) {
    Properties properties = new Properties();
    properties.put(Merlin.PREFIX + Merlin.TRUSTSTORE_FILE, trustStoreConfiguration.getPath());
    String type = trustStoreConfiguration.getType();
    if (type != null) {
      properties.put(Merlin.PREFIX + Merlin.TRUSTSTORE_TYPE, type);
    }
    String password = trustStoreConfiguration.getPassword();
    if (password != null) {
      properties.put(Merlin.PREFIX + Merlin.TRUSTSTORE_PASSWORD, password);
    }
    return properties;
  }
}
