/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.outbound;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

import com.mulesoft.modules.wss.api.outbound.SignatureConfig;
import com.mulesoft.modules.wss.api.outbound.EncryptionConfig;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@Operations({WssOutboundOperations.class})
@Configuration(name = "outbound")
public class WssOutboundConfig implements Initialisable {

  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  @ParameterDsl(allowReferences = false)
  @DisplayName("Signature Configuration")
  private SignatureConfig signatureConfig;

  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  @ParameterDsl(allowReferences = false)
  @DisplayName("Encryption Configuration")
  private EncryptionConfig encryptionConfig;

  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  @DisplayName("'Must Understand' Attribute")
  private boolean mustUnderstand;

  @Override
  public void initialise() throws InitialisationException {
    if (encryptionConfig == null && signatureConfig == null) {
      throw new InitialisationException(createStaticMessage("No WSS config was found in config, at least one is required"), this);
    }
  }

  public SignatureConfig getSignatureConfig() {
    return signatureConfig;
  }

  public boolean getMustUnderstand() {
    return mustUnderstand;
  }

  public EncryptionConfig getEncryptionConfig() {
    return encryptionConfig;
  }
}
