/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Message Digest Algorithm to be used for the digest algorithm that is used with the key transport algorithm for encryption.
 * Listed on the <a href="https://www.w3.org/TR/xmlenc-core1/">W3C XML Encryption specification</a>.
 *
 * @since 1.0
 */
public enum EncryptionDigestAlgorithmConstants {

  SHA1("http://www.w3.org/2000/09/xmldsig#sha1"), SHA256("http://www.w3.org/2001/04/xmlenc#sha256"), SHA384(
      "http://www.w3.org/2001/04/xmldsig-more#sha384"), SHA512("http://www.w3.org/2001/04/xmlenc#sha512");

  private String value;

  EncryptionDigestAlgorithmConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}
