/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

import org.apache.wss4j.common.saml.builder.SAML1Constants;
import org.apache.wss4j.common.saml.builder.SAML2Constants;

/**
 * Subject Confirmation Method of SAML Assertions.
 *
 * @since 1.0
 */
public enum SamlConfirmationMethod {

  BEARER(SAML1Constants.CONF_BEARER, SAML2Constants.CONF_BEARER),

  HOLDER_OF_KEY(SAML1Constants.CONF_HOLDER_KEY, SAML2Constants.CONF_HOLDER_KEY),

  SENDER_VOUCHES(SAML1Constants.CONF_SENDER_VOUCHES, SAML2Constants.CONF_SENDER_VOUCHES);

  private String saml1Uri;
  private String saml2Uri;

  SamlConfirmationMethod(String saml1Uri, String saml2Uri) {
    this.saml1Uri = saml1Uri;
    this.saml2Uri = saml2Uri;
  }

  public String getMethodStringForSAML(SamlVersion samlVersion) {
    return samlVersion.equals(SamlVersion.SAML20) ? saml2Uri : saml1Uri;
  }
}
