/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import com.mulesoft.modules.wss.api.constants.SamlConfirmationMethod;
import com.mulesoft.modules.wss.api.constants.SamlVersion;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.concurrent.TimeUnit;

import static com.mulesoft.modules.wss.api.constants.SamlVersion.SAML10;
import static java.util.concurrent.TimeUnit.SECONDS;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Security Assertion Markup Language (SAML) related configuration used for verifying SAML Assertions.
 *
 * @since 1.0
 */
public class VerifySamlConfig {

  /**
   * SAML Version.
   */
  @Parameter
  @Optional(defaultValue = "SAML10")
  @Summary("SAML Version.")
  @Expression(NOT_SUPPORTED)
  private SamlVersion samlVersion = SAML10;

  /**
   * The time in seconds within which a SAML Assertion is valid,
   * if it does not contain a NotOnOrAfter Condition. The default is 30 minutes.
   */
  @Parameter
  @Optional(defaultValue = "1800")
  @Summary("The time in seconds within which a SAML Assertion is valid, if it does not contain a NotOnOrAfter Condition. The default is 30 minutes.")
  @Expression(NOT_SUPPORTED)
  private Integer timeToLive = 1800;

  /**
   * The time difference between server and client. The default is 60 seconds.
   */
  @Parameter
  @Optional(defaultValue = "60")
  @Summary("The time difference between server and client. The default is 60 seconds.")
  @Expression(NOT_SUPPORTED)
  private Integer skewTime = 60;

  /**
   * Time unit to be used in the timeToLive and skewTime configuration.
   */
  @Parameter
  @Optional(defaultValue = "SECONDS")
  @Summary("Time unit to be used in the timeToLive and skewTime configuration.")
  private TimeUnit timeUnit = SECONDS;

  /**
   * If set, at least one of the standard Subject Confirmation Methods in {@link SamlConfirmationMethod}
   * *must* be present in the assertion (Bearer / SenderVouches / HolderOfKey).
   */
  @Parameter
  @Optional(defaultValue = "false")
  @Summary("If set, at least one of the standard Subject Confirmation Methods must be present in the assertion.")
  @Expression(NOT_SUPPORTED)
  private boolean requireStandardSubjectConfirmationMethod;

  /**
   * If set, an Assertion with a Bearer Subject Confirmation Method must be signed.
   */
  @Parameter
  @Optional(defaultValue = "false")
  @Summary("If set, an Assertion with a Bearer Subject Confirmation Method must be signed.")
  @Expression(NOT_SUPPORTED)
  private boolean requireBearerSignature;

  /**
   * Whether to validate the signature of the Assertion (if it exists) against the
   * relevant profile. Default is true.
   */
  @Parameter
  @Optional(defaultValue = "false")
  @Summary("Whether to validate the signature of the Assertion against the relevant profile. Default is true.")
  @Expression(NOT_SUPPORTED)
  private boolean validateSignatureAgainstProfile;

  /**
   * If set, the value must appear as one of the Subject Confirmation Methods {@link SamlConfirmationMethod}.
   */
  @Parameter
  @Optional
  @Summary("If set, the value must appear as one of the Subject Confirmation Methods.")
  @Expression(NOT_SUPPORTED)
  private SamlConfirmationMethod requiredSubjectConfirmationMethod;

  public SamlVersion getSamlVersion() {
    return samlVersion;
  }

  public Integer getTimeToLive() {
    return timeToLive;
  }

  public Integer getSkewTime() {
    return skewTime;
  }

  public TimeUnit getTimeUnit() {
    return timeUnit;
  }

  public boolean isRequireStandardSubjectConfirmationMethod() {
    return requireStandardSubjectConfirmationMethod;
  }

  public boolean isRequireBearerSignature() {
    return requireBearerSignature;
  }

  public boolean isValidateSignatureAgainstProfile() {
    return validateSignatureAgainstProfile;
  }

  public SamlConfirmationMethod getRequiredSubjectConfirmationMethod() {
    return requiredSubjectConfirmationMethod;
  }
}
