/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.auth;

import org.mule.runtime.api.security.Authentication;

import java.util.HashMap;
import java.util.Map;

import static java.lang.Boolean.TRUE;

public class MustUnderstandAuthentication implements Authentication {

  private static final String MU_AUTH_PROPERTY = MustUnderstandAuthentication.class.getSimpleName() + "Property";

  // making this mutable since other implementations may abuse of it and we cannot fail :D
  private Map<String, Object> props = new HashMap<>();

  public MustUnderstandAuthentication() {
    props.put(MU_AUTH_PROPERTY, TRUE);
  }

  // Do nothing
  @Override
  public Object getCredentials() {
    return new Object();
  }

  // Do nothing
  @Override
  public Object getPrincipal() {
    return new Object();
  }

  @Override
  public Map<String, Object> getProperties() {
    return props;
  }

  @Override
  public Authentication setProperties(Map<String, Object> props) {
    this.props = props;
    return this;
  }
}
