/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Constant that indicates whether to sign an Element or a Content.
 * <p>
 * For more information regarding the difference between Element and Content refer to the
 * <a href="https://www.w3.org/TR/xmldsig-core1/">W3C XML Signature specification</a>.
 *
 * @since 1.0
 */
public enum SignEncodeConstants {

  ELEMENT("Element"), CONTENT("Content");

  private String value;

  SignEncodeConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}
