/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Signature Method Algorithm to be used to sign.
 * Listed on the <a href="https://www.w3.org/TR/xmldsig-core1/">W3C XML Signature specification</a>.
 *
 * @since 1.0
 */
public enum SignatureAlgorithmConstants {

  RSAwithSHA256("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"), ECDSAwithSHA256(
      "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"), DSAwithSHA1(
          "http://www.w3.org/2000/09/xmldsig#dsa-sha1"), RSAwithSHA1("http://www.w3.org/2000/09/xmldsig#rsa-sha1"), RSAwithSHA224(
              "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"), RSAwithSHA384(
                  "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"), RSAwithSHA512(
                      "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"), ECDSAwithSHA1(
                          "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"), ECDSAwithSHA224(
                              "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"), ECDSAwithSHA384(
                                  "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"), ECDSAwithSHA512(
                                      "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"), DSAwithSHA256(
                                          "http://www.w3.org/2009/xmldsig11#dsa-sha256");

  private String value;

  SignatureAlgorithmConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }

}
