/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Signature Digest Algorithm to be used for the digest algorithm.
 * Listed on the <a href="https://www.w3.org/TR/xmldsig-core1/">W3C XML Signature specification</a>.
 *
 * @since 1.0
 */
public enum SignatureDigestAlgorithmConstants {

  SHA1("http://www.w3.org/2000/09/xmldsig#sha1"), SHA256("http://www.w3.org/2001/04/xmlenc#sha256"), SHA224(
      "http://www.w3.org/2001/04/xmldsig-more#sha224"), SHA384(
          "http://www.w3.org/2001/04/xmldsig-more#sha384"), SHA512("http://www.w3.org/2001/04/xmlenc#sha512");

  private String value;

  SignatureDigestAlgorithmConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}
