/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.handler;

import com.mulesoft.modules.wss.api.inbound.CredentialsConfig;
import org.apache.wss4j.common.ext.WSPasswordCallback;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import java.util.HashMap;
import java.util.Map;

import static org.apache.wss4j.common.ext.WSPasswordCallback.DECRYPT;
import static org.apache.wss4j.common.ext.WSPasswordCallback.USERNAME_TOKEN;

public class CredentialsCallbackHandler implements CallbackHandler {

  private final Map<Integer, CredentialsConfig> configs = new HashMap<>();

  public void setUsernameTokenCredentials(CredentialsConfig credentials) {
    configs.put(USERNAME_TOKEN, credentials);
  }

  public void setDecryptionConfigCredentials(CredentialsConfig credentials) {
    configs.put(DECRYPT, credentials);
  }

  @Override
  public void handle(Callback[] callbacks) {
    for (Callback callback : callbacks) {
      if (callback instanceof WSPasswordCallback) {
        WSPasswordCallback cb = (WSPasswordCallback) callback;
        CredentialsConfig credentialsConfig = configs.get(cb.getUsage());
        if (credentialsConfig != null) {
          if (cb.getIdentifier().equals(credentialsConfig.getUsername())) {
            cb.setPassword(credentialsConfig.getPassword());
          }
        }
      }
    }
  }
}

