/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.inbound;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import com.mulesoft.modules.wss.internal.error.WssSecurityException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;

public class LDAPValidator implements Validator {

  private LdapAuthenticationProvider authenticationProvider;

  public LDAPValidator(LdapAuthenticationProvider authenticationProvider) {
    this.authenticationProvider = authenticationProvider;
  }

  @Override
  public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
    try {
      UsernameToken usernameToken = credential.getUsernametoken();

      if (!WSConstants.PASSWORD_TEXT.equals(usernameToken.getPasswordType())) {
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
      }
      UsernamePasswordAuthenticationToken token =
          new UsernamePasswordAuthenticationToken(usernameToken.getName(), usernameToken.getPassword());

      if (!authenticationProvider.authenticate(token).isAuthenticated()) {
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
      }
      return credential;
    } catch (WssSecurityException e) {
      throw e;
    } catch (Exception e) {
      throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, e);
    }
  }
}
