/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.util;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.modules.wss.api.constants.SoapVersion;
import com.mulesoft.modules.wss.internal.error.WssException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

import static com.mulesoft.modules.wss.api.constants.SoapVersion.SOAP_11;
import static org.hamcrest.core.IsEqual.equalTo;

@PrepareForTest(SoapMessageHandler.class)
@RunWith(PowerMockRunner.class)
public class SoapMessageHandlerTestCase {

  @Rule
  public ExpectedException expected = ExpectedException.none();

  @Test
  public void emptyInputStream() {
    expected.expectMessage(equalTo("Unable to obtain SOAP request from payload"));
    expected.expect(WssException.class);
    new SoapMessageHandler()
        .create(new ByteArrayInputStream("".getBytes()), null, SoapVersion.SOAP_11);
  }

  @Test
  public void nullSoapVersion() {
    expected.expectMessage(equalTo("Invalid SOAP Version [null]"));
    expected.expect(WssException.class);
    new SoapMessageHandler()
        .create(new ByteArrayInputStream("".getBytes()), null, null);
  }

  @Test
  public void messageFactoryCreateMessageException() {
    expected.expectMessage(equalTo("Unable to obtain SOAP request from payload"));
    expected.expect(WssException.class);
    MessageFactory messageFactory = new MessageFactory() {

      @Override
      public SOAPMessage createMessage() {
        return null;
      }

      @Override
      public SOAPMessage createMessage(MimeHeaders headers, InputStream in)
          throws SOAPException {
        throw new SOAPException("Testing exception");
      }
    };
    Whitebox.setInternalState(SoapMessageHandler.class, "factories", ImmutableMap.of(SOAP_11, messageFactory));
    SoapMessageHandler soapMessageHandler = new SoapMessageHandler();

    soapMessageHandler.create(new ByteArrayInputStream("valid soap request".getBytes()), null, SoapVersion.SOAP_11);
  }

}
