/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Key Transport Algorithm to be used to encrypt the symmetric key.
 * Listed on the <a href="https://www.w3.org/TR/xmlenc-core1/">W3C XML Encryption specification</a>.
 *
 * @since 1.0
 */
public enum EncryptionKeyTransportAlgorithmConstants {
  KEYTRANSPORT_RSA15("http://www.w3.org/2001/04/xmlenc#rsa-1_5"), KEYTRANSPORT_RSAOAEP(
      "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"), KEYTRANSPORT_RSAOAEP_XENC11("http://www.w3.org/2009/xmlenc11#rsa-oaep");

  private String value;

  EncryptionKeyTransportAlgorithmConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}
