/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.constants;

/**
 * Block Encryption Algorithm to be used to encrypt the symmetric key.
 * Listed on the <a href="https://www.w3.org/TR/xmlenc-core1/">W3C XML Encryption specification</a>.
 *
 * @since 1.0
 */
public enum EncryptionSymAlgorithmConstants {

  TRIPLE_DES("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"), AES_128("http://www.w3.org/2001/04/xmlenc#aes128-cbc"), AES_256(
      "http://www.w3.org/2001/04/xmlenc#aes256-cbc"), AES_192("http://www.w3.org/2001/04/xmlenc#aes192-cbc"), AES_128_GCM(
          "http://www.w3.org/2009/xmlenc11#aes128-gcm"), AES_192_GCM(
              "http://www.w3.org/2009/xmlenc11#aes192-gcm"), AES_256_GCM("http://www.w3.org/2009/xmlenc11#aes256-gcm");

  private String value;

  EncryptionSymAlgorithmConstants(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return value;
  }
}
