/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

/**
 * Authentication configuration sub-type based on credentials.
 *
 * @since 1.0
 */
public class CredentialsConfig implements AuthenticateUserConfig {

  /**
   * Username.
   */
  @Parameter
  @Summary("Username.")
  private String username;

  /**
   * Password.
   */
  @Parameter
  @Summary("Password.")
  @Password
  private String password;

  public CredentialsConfig() {}

  public CredentialsConfig(String username, String password) {
    this.username = username;
    this.password = password;
  }

  public String getUsername() {
    return username;
  }

  public String getPassword() {
    return password;
  }

}
