/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.inbound;

import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Decryption configuration.
 *
 * @since 1.0
 */
public class DecryptionConfig {

  /**
   * KeyStore configuration used for decryption.
   */
  @Parameter
  @DisplayName("KeyStore Configuration")
  @Summary("KeyStore configuration used for decryption.")
  @Expression(NOT_SUPPORTED)
  @Alias("keystore-config")
  private KeyStoreConfiguration keyStoreConfig;

  public KeyStoreConfiguration getKeyStoreConfig() {
    return keyStoreConfig;
  }

}
