/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.outbound;

import com.mulesoft.modules.wss.api.constants.EncryptionDigestAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionKeyIdentifierConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionKeyTransportAlgorithmConstants;
import com.mulesoft.modules.wss.api.constants.EncryptionSymAlgorithmConstants;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Encryption configuration.
 *
 * @since 1.0
 */
public class EncryptionConfig extends BaseOutboundConfig {

  /**
   * The key identifier type to use for encryption.
   */
  @Parameter
  @Optional(defaultValue = "ISSUER_SERIAL")
  @Summary("The key identifier type to use for encryption.")
  @Expression(NOT_SUPPORTED)
  private EncryptionKeyIdentifierConstants encryptionKeyIdentifier;

  /**
   * The symmetric encryption algorithm to use.
   */
  @Parameter
  @Optional(defaultValue = "AES_128")
  @Summary("The symmetric encryption algorithm to use.")
  @Expression(NOT_SUPPORTED)
  private EncryptionSymAlgorithmConstants encryptionSymAlgorithm;

  /**
   * The algorithm used to encrypt the generated symmetric key.
   */
  @Parameter
  @Optional(defaultValue = "KEYTRANSPORT_RSAOAEP")
  @Summary("The algorithm used to encrypt the generated symmetric key.")
  @Expression(NOT_SUPPORTED)
  private EncryptionKeyTransportAlgorithmConstants encryptionKeyTransportAlgorithm;

  /**
   * The encryption digest algorithm to use with the key transport algorithm.
   */
  @Parameter
  @Optional(defaultValue = "SHA1")
  @Summary("The encryption digest algorithm to use with the key transport algorithm.")
  @Expression(NOT_SUPPORTED)
  private EncryptionDigestAlgorithmConstants encryptionDigestAlgorithm;

  /**
   * KeyStore configuration used for encryption.
   */
  @Parameter
  @Optional
  @DisplayName("KeyStore Configuration")
  @Summary("KeyStore configuration used for encryption.")
  @Expression(NOT_SUPPORTED)
  @Alias("keystore-config")
  private KeyStoreConfiguration keyStoreConfiguration;

  public EncryptionKeyIdentifierConstants getEncryptionKeyIdentifier() {
    return encryptionKeyIdentifier;
  }

  public EncryptionSymAlgorithmConstants getEncryptionSymAlgorithm() {
    return encryptionSymAlgorithm;
  }

  public EncryptionKeyTransportAlgorithmConstants getEncryptionKeyTransportAlgorithm() {
    return encryptionKeyTransportAlgorithm;
  }

  public EncryptionDigestAlgorithmConstants getEncryptionDigestAlgorithm() {
    return encryptionDigestAlgorithm;
  }

  public KeyStoreConfiguration getKeyStoreConfiguration() {
    return keyStoreConfiguration;
  }

}
