/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.api.outbound;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.concurrent.TimeUnit;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

/**
 * Timestamp configuration used to add a timestamp to security header.
 *
 * @since 1.1.0
 */
public class TimestampConfig {

  /**
   * The time within which the Timestamp element is valid. The default is 5 minutes.
   */
  @Parameter
  @Optional(defaultValue = "300")
  @Summary("The time within which the Timestamp element is valid. The default is 5 minutes.")
  @Expression(NOT_SUPPORTED)
  private Integer timeToLive;

  /**
   * Time unit to be used in the timeToLive configuration.
   */
  @Parameter
  @Optional(defaultValue = "SECONDS")
  @Summary("Time unit to be used in the timeToLive configuration.")
  @Expression(NOT_SUPPORTED)
  private TimeUnit timeUnit;

  /**
   * If set to true then use timestamps with milliseconds, otherwise omit the milliseconds.
   */
  @Parameter
  @Optional(defaultValue = "true")
  @Summary("If set to true then use timestamps with milliseconds, otherwise omit the milliseconds.")
  @Expression(NOT_SUPPORTED)
  private boolean precisionInMilliseconds;

  public Integer getTimeToLive() {
    return timeToLive;
  }

  public TimeUnit getTimeUnit() {
    return timeUnit;
  }

  public boolean isPrecisionInMilliseconds() {
    return precisionInMilliseconds;
  }
}
