/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal;

import com.mulesoft.modules.wss.api.inbound.AuthenticateUserConfig;
import com.mulesoft.modules.wss.api.inbound.CredentialsConfig;
import com.mulesoft.modules.wss.api.inbound.LDAPConfig;
import com.mulesoft.modules.wss.internal.error.WssError;
import com.mulesoft.modules.wss.internal.inbound.WssInboundConfig;
import com.mulesoft.modules.wss.internal.outbound.WssOutboundConfig;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@Extension(name = "WSS", category = Category.SELECT)
@SubTypeMapping(baseType = AuthenticateUserConfig.class, subTypes = {CredentialsConfig.class, LDAPConfig.class})
@DisplayName("WS-Security")
@Configurations(value = {WssInboundConfig.class, WssOutboundConfig.class})
@ErrorTypes(WssError.class)
public class WssModule {

}
