/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.inbound;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;

public class SamlValidator extends SamlAssertionValidator {

  private final boolean verifyTrustChain;

  /**
   * data.getSigVerCrypto() checks if signature verification is enabled
   * in that case, trust will be validated against configured trust-store
   * @param data
   */
  public SamlValidator(RequestData data) {
    this.verifyTrustChain = data.getSigVerCrypto() != null;
    data.setValidateSamlSubjectConfirmation(verifyTrustChain);
  }

  protected Credential verifySignedAssertion(SamlAssertionWrapper samlAssertion, RequestData data) throws WSSecurityException {
    if (verifyTrustChain) {
      return super.verifySignedAssertion(samlAssertion, data);
    }
    return null;
  }

}
