/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.security;

import com.mulesoft.modules.wss.internal.auth.MustUnderstandAuthentication;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.core.api.security.AbstractSecurityProvider;

public class SoapWssSecurityProvider extends AbstractSecurityProvider {

  public static final String ID = SoapWssSecurityProvider.class.getSimpleName() + "KeyId";

  public SoapWssSecurityProvider() {
    super(ID);
  }

  @Override
  public Authentication authenticate(Authentication authentication) {
    return authentication;
  }

  @Override
  public boolean supports(Class<?> aClass) {
    return aClass.getName().equals(MustUnderstandAuthentication.class.getName());
  }
}
