/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.wss.internal.outbound;

import com.mulesoft.modules.wss.api.outbound.TimestampConfig;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.InitialisationException;

import java.util.concurrent.TimeUnit;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class WssOutboundConfigTestCase {

  @Rule
  public ExpectedException expected = ExpectedException.none();

  @Test
  public void ttlExceedsMaximumLimit() throws InitialisationException {
    expected.expect(InitialisationException.class);
    expected.expectMessage("Time to live configuration value exceeds limit");
    WssOutboundConfig outboundConfig = mock(WssOutboundConfig.class);
    TimestampConfig timestampConfig = mock(TimestampConfig.class);
    when(timestampConfig.getTimeToLive()).thenReturn(25000);
    when(timestampConfig.getTimeUnit()).thenReturn(TimeUnit.DAYS);
    when(outboundConfig.getOutboundTimestampConfig()).thenReturn(timestampConfig);
    Mockito.doCallRealMethod().when(outboundConfig).initialise();
    outboundConfig.initialise();
  }

}
