/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.internal.outbound;

import com.mulesoft.modules.wss.api.constants.SoapVersion;
import com.mulesoft.modules.wss.api.outbound.EncryptionConfig;
import com.mulesoft.modules.wss.api.outbound.SignatureConfig;
import com.mulesoft.modules.wss.api.outbound.TimestampConfig;
import com.mulesoft.modules.wss.internal.error.WssApplyException;
import com.mulesoft.modules.wss.internal.error.WssErrorTypeProvider;
import com.mulesoft.modules.wss.internal.handler.OutboundConfigHandler;
import com.mulesoft.modules.wss.internal.outbound.WssOutboundConfig;
import com.mulesoft.modules.wss.internal.util.SoapMessageHandler;
import jakarta.xml.soap.SOAPMessage;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.w3c.dom.Document;

public class WssOutboundOperations {
    private static final SoapMessageHandler ENVELOPE_DOCUMENT_FACTORY = new SoapMessageHandler();
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager runtimeObjectStoreManager;

    @Throws(value={WssErrorTypeProvider.class})
    @MediaType(value="application/xml", strict=false)
    @DisplayName(value="Apply WSS")
    public Result<InputStream, Void> applyWss(@Config WssOutboundConfig config, @Content TypedValue<InputStream> response, @Optional(defaultValue="SOAP_12") SoapVersion version, CorrelationInfo correlationInfo) {
        try {
            String contentType = response.getDataType().getMediaType().toRfcString();
            SOAPMessage soapMessage = ENVELOPE_DOCUMENT_FACTORY.create((InputStream)response.getValue(), contentType, version);
            Document envelope = soapMessage.getSOAPPart().getDocumentElement().getOwnerDocument();
            WSSecHeader securityHeader = new WSSecHeader(envelope);
            securityHeader.setMustUnderstand(config.getMustUnderstand());
            securityHeader.insertSecurityHeader();
            this.applyConfigs(config, correlationInfo.getCorrelationId(), securityHeader);
            InputStream result = ENVELOPE_DOCUMENT_FACTORY.serialize(soapMessage);
            return Result.builder().output((Object)result).mediaType(org.mule.runtime.api.metadata.MediaType.parse((String)contentType)).build();
        }
        catch (Exception e) {
            throw new WssApplyException(e);
        }
    }

    private void applyConfigs(WssOutboundConfig config, String correlationId, WSSecHeader securityHeader) {
        SignatureConfig signatureConfig = config.getSignatureConfig();
        EncryptionConfig encryptionConfig = config.getEncryptionConfig();
        TimestampConfig timestampConfig = config.getOutboundTimestampConfig();
        OutboundConfigHandler outboundConfigHandler = new OutboundConfigHandler(securityHeader);
        if (timestampConfig != null) {
            outboundConfigHandler.handle(timestampConfig);
        }
        if (signatureConfig != null) {
            outboundConfigHandler.handle(signatureConfig);
        }
        if (encryptionConfig != null) {
            outboundConfigHandler.handle(encryptionConfig, this.runtimeObjectStoreManager, correlationId);
        }
    }
}

