/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.inbound;

import com.mulesoft.modules.wss.api.constants.SamlConfirmationMethod;
import com.mulesoft.modules.wss.api.constants.SamlVersion;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class VerifySamlConfig {
    @Parameter
    @Optional(defaultValue="SAML10")
    @Summary(value="SAML Version.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SamlVersion samlVersion = SamlVersion.SAML10;
    @Parameter
    @Optional(defaultValue="1800")
    @Summary(value="The time in seconds within which a SAML Assertion is valid, if it does not contain a NotOnOrAfter Condition. The default is 30 minutes.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer timeToLive = 1800;
    @Parameter
    @Optional(defaultValue="60")
    @Summary(value="The time difference between server and client. The default is 60 seconds.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer skewTime = 60;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Summary(value="Time unit to be used in the timeToLive and skewTime configuration.")
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="If set, at least one of the standard Subject Confirmation Methods must be present in the assertion.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean requireStandardSubjectConfirmationMethod;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="If set, an Assertion with a Bearer Subject Confirmation Method must be signed.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean requireBearerSignature;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Whether to validate the signature of the Assertion against the relevant profile. Default is true.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean validateSignatureAgainstProfile;
    @Parameter
    @Optional
    @Summary(value="If set, the value must appear as one of the Subject Confirmation Methods.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SamlConfirmationMethod requiredSubjectConfirmationMethod;

    public SamlVersion getSamlVersion() {
        return this.samlVersion;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public Integer getSkewTime() {
        return this.skewTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public boolean isRequireStandardSubjectConfirmationMethod() {
        return this.requireStandardSubjectConfirmationMethod;
    }

    public boolean isRequireBearerSignature() {
        return this.requireBearerSignature;
    }

    public boolean isValidateSignatureAgainstProfile() {
        return this.validateSignatureAgainstProfile;
    }

    public SamlConfirmationMethod getRequiredSubjectConfirmationMethod() {
        return this.requiredSubjectConfirmationMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifySamlConfig that = (VerifySamlConfig)o;
        return this.requireStandardSubjectConfirmationMethod == that.requireStandardSubjectConfirmationMethod && this.requireBearerSignature == that.requireBearerSignature && this.validateSignatureAgainstProfile == that.validateSignatureAgainstProfile && this.samlVersion == that.samlVersion && Objects.equals(this.timeToLive, that.timeToLive) && Objects.equals(this.skewTime, that.skewTime) && this.timeUnit == that.timeUnit && this.requiredSubjectConfirmationMethod == that.requiredSubjectConfirmationMethod;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.samlVersion, this.timeToLive, this.skewTime, this.timeUnit, this.requireStandardSubjectConfirmationMethod, this.requireBearerSignature, this.validateSignatureAgainstProfile, this.requiredSubjectConfirmationMethod});
    }
}

