/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.helpers.logger;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.extension.helpers.logger.ConnectorLogger;
import org.mule.extension.helpers.logger.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConnectorLoggerImpl
implements ConnectorLogger {
    private static final Marker ENTRY_POINT_MARKER = MarkerFactory.getMarker((String)"ENTRY_POINT");
    private static final Marker HEAVY_LOGIC_MARKER = MarkerFactory.getMarker((String)"HEAVY_LOGIC");
    private static final Marker DECISION_MARKER = MarkerFactory.getMarker((String)"DECISION");
    private static final Marker TRANSIENT_ERROR_MARKER = MarkerFactory.getMarker((String)"TRANSIENT_ERROR");
    private static final Marker ERROR_MARKER = MarkerFactory.getMarker((String)"ERROR");
    private final Logger logger;

    public static ConnectorLogger newInstance(Class<?> source) {
        return new ConnectorLoggerImpl(LoggerFactory.getLogger(source));
    }

    public static ConnectorLogger newInstance(Class<?> source, Function<Class<?>, Logger> loggerSupplier) {
        return new ConnectorLoggerImpl(loggerSupplier.apply(source));
    }

    private ConnectorLoggerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void trace(ConnectorLogger.TraceKeywords verb, String area) {
        this.trace(verb, area, null);
    }

    @Override
    public void trace(ConnectorLogger.TraceKeywords verb, String area, Supplier<Map<String, Object>> arguments) {
        if (this.logger.isTraceEnabled()) {
            if (ConnectorLoggerImpl.hasArguments(arguments)) {
                this.logger.trace(ENTRY_POINT_MARKER, "{} {}. Arguments: {}.", new Object[]{verb, area, arguments.get()});
            } else {
                this.logger.trace(ENTRY_POINT_MARKER, "{} {}.", (Object)verb, (Object)area);
            }
        }
    }

    @Override
    public void debug(String action) {
        this.debug(action, null);
    }

    @Override
    public void debug(String action, Supplier<Map<String, Object>> arguments) {
        if (this.logger.isDebugEnabled()) {
            if (ConnectorLoggerImpl.hasArguments(arguments)) {
                this.logger.debug(HEAVY_LOGIC_MARKER, "{}. Arguments: {}.", (Object)action, arguments.get());
            } else {
                this.logger.debug(HEAVY_LOGIC_MARKER, "{}.", (Object)action);
            }
        }
    }

    @Override
    public void info(String cause, String decision) {
        this.info(cause, decision, null);
    }

    @Override
    public void info(String cause, String decision, Supplier<Map<String, Object>> arguments) {
        if (this.logger.isInfoEnabled()) {
            if (ConnectorLoggerImpl.hasArguments(arguments)) {
                this.logger.info(DECISION_MARKER, "{}. {}. Arguments: {}.", new Object[]{cause, decision, arguments.get()});
            } else {
                this.logger.info(DECISION_MARKER, "{}. {}.", (Object)cause, (Object)decision);
            }
        }
    }

    @Override
    public void warn(String verb, String reason, String resolution) {
        this.warn(verb, reason, resolution, null, null);
    }

    @Override
    public void warn(String verb, String reason, String resolution, Exception exception) {
        this.warn(verb, reason, resolution, exception, null);
    }

    @Override
    public void warn(String verb, String reason, String resolution, Supplier<Map<String, Object>> arguments) {
        this.warn(verb, reason, resolution, null, arguments);
    }

    @Override
    public void warn(String verb, String reason, String resolution, Exception exception, Supplier<Map<String, Object>> arguments) {
        if (this.logger.isWarnEnabled()) {
            if (ConnectorLoggerImpl.hasArguments(arguments)) {
                if (exception != null) {
                    this.logger.warn(TRANSIENT_ERROR_MARKER, "Couldn't {} because {}. {}. Root exception was: {}. Arguments: {}.", new Object[]{verb, reason, resolution, LoggerUtils.getStackTrace(exception), arguments.get(), exception});
                } else {
                    this.logger.warn(TRANSIENT_ERROR_MARKER, "Couldn't {} because {}. {}. Arguments: {}.", new Object[]{verb, reason, resolution, arguments.get()});
                }
            } else if (exception != null) {
                this.logger.warn(TRANSIENT_ERROR_MARKER, "Couldn't {} because {}. {}. Root exception was: {}.", new Object[]{verb, reason, resolution, LoggerUtils.getStackTrace(exception), exception});
            } else {
                this.logger.warn(TRANSIENT_ERROR_MARKER, "Couldn't {} because {}. {}.", new Object[]{verb, reason, resolution});
            }
        }
    }

    @Override
    public void error(String description, Exception exception) {
        this.error(description, exception, (String)null);
    }

    @Override
    public void error(String description, Exception exception, String logFileLocation) {
        this.error(description, exception, null, logFileLocation);
    }

    @Override
    public void error(String description, Exception exception, Supplier<Map<String, Object>> arguments) {
        this.error(description, exception, arguments, null);
    }

    @Override
    public void error(String description, Exception exception, Supplier<Map<String, Object>> arguments, String logFileLocation) {
        if (this.logger.isErrorEnabled()) {
            StringBuffer message = new StringBuffer("An error has occurred while ").append(description).append(".");
            if (logFileLocation != null) {
                message.append(" Please see the complete log file: ").append(logFileLocation).append(".");
            }
            if (exception != null) {
                message.append(" Root exception was: ").append(LoggerUtils.getStackTrace(exception)).append(".");
            }
            if (ConnectorLoggerImpl.hasArguments(arguments)) {
                message.append(" Arguments: ").append(arguments.get()).append(".");
            }
            this.logger.error(ERROR_MARKER, message.toString(), (Throwable)exception);
        }
    }

    private static boolean hasArguments(Supplier<Map<String, Object>> arguments) {
        return arguments != null && arguments.get().size() > 0;
    }

    public static Map<String, Object> quickMap(Object[][] objects) {
        return Stream.of(objects).filter(e -> e[0] != null && e[1] != null).collect(Collectors.toMap(data -> (String)data[0], data -> data[1]));
    }

    public static Map<String, Object> quickMap(String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        HashMap<String, Object> result = new HashMap<String, Object>(ConnectorLoggerImpl.quickMap(key1, value1, key2, value2));
        result.put(key3, value3);
        return result;
    }

    public static Map<String, Object> quickMap(String key1, Object value1, String key2, Object value2) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(ConnectorLoggerImpl.quickMap(key1, value1));
        result.putAll(ConnectorLoggerImpl.quickMap(key2, value2));
        return result;
    }

    public static Map<String, Object> quickMap(String key, Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, value);
        return result;
    }
}

