/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.builder;

import com.mulesoft.mule.debugger.dto.FieldNode;
import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.properties.MuleDebuggerProperties;
import com.mulesoft.mule.debugger.util.ClassUtils;
import com.mulesoft.mule.debugger.util.DataWeaveUtils;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFieldDefinitionFactory {
    public static final String NULL_DW_ACCESSOR = null;
    public static final String KEY_NAME = "key";
    public static final String VALUE_NAME = "value";
    public static final String SIZE = "size = ";
    public static final String PREFIX_PAYLOAD_TOO_LONG = "Your payload is not fully displayed as its content is too large to be shown... ";
    private static final Logger logger = LoggerFactory.getLogger(ObjectFieldDefinitionFactory.class);

    private ObjectFieldDefinitionFactory() {
        throw new IllegalStateException("Not meant to be instanciated");
    }

    private static ObjectFieldDefinition createChildField(Object value, Class type, FieldPath parentPath, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor) {
        FieldPath path = parentPath.addChild(new FieldNode(name));
        return ObjectFieldDefinitionFactory.create(value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor);
    }

    private static ObjectFieldDefinition create(Object value, Class<?> valueType, FieldPath fieldPath, String name, Charset charset, String dwAccessor) {
        return ObjectFieldDefinitionFactory.create(value, valueType, fieldPath, name, new HashMap<FieldIdentifier, ObjectFieldDefinition>(), 0, 0, MuleDebuggerProperties.DEFAULT_MAX_DEPTH_PROPERTY, charset, dwAccessor);
    }

    public static ObjectFieldDefinition create(Object value, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor) {
        ObjectFieldDefinition result;
        ++depth;
        FieldIdentifier fieldIdentifier = new FieldIdentifier(value, name);
        if (processed.containsKey(fieldIdentifier)) {
            return processed.get(fieldIdentifier);
        }
        if (value == null || type.isPrimitive() || ClassUtils.isWrapperType(type) || value instanceof String) {
            result = ObjectFieldDefinitionFactory.createSimpleField(value, type, name, modifiers, path, dwAccessor);
            processed.put(fieldIdentifier, result);
        } else if (value instanceof byte[]) {
            byte[] val = (byte[])value;
            result = ObjectFieldDefinitionFactory.createSimpleField(new String(val, charset), type, name, modifiers, path, dwAccessor);
            processed.put(fieldIdentifier, result);
        } else if (type.isArray()) {
            result = ObjectFieldDefinitionFactory.createArrayDefinition(value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
        } else if (value instanceof CursorStreamProvider) {
            result = ObjectFieldDefinitionFactory.createCursorStreamProviderDefinition(value, path, name, processed, modifiers, charset, dwAccessor, fieldIdentifier);
        } else if (value instanceof CursorIteratorProvider) {
            result = ObjectFieldDefinitionFactory.createCursorIteratorProviderDefinition((CursorIteratorProvider)value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
        } else if (value instanceof Collection) {
            result = ObjectFieldDefinitionFactory.createCollectionFieldDefinition((Collection)value, type, path, name, processed, modifiers, depth, maxDepth, fieldIdentifier, charset, dwAccessor);
        } else if (value instanceof MultiMap) {
            result = ObjectFieldDefinitionFactory.createMultiMapDefinition((MultiMap)value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
        } else if (value instanceof Map) {
            result = ObjectFieldDefinitionFactory.createMapDefinition((Map)value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
        } else if (value instanceof Error) {
            result = ObjectFieldDefinitionFactory.createGenericPojoDefinition(value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
            result.markAsErrorRecursively();
        } else {
            result = ObjectFieldDefinitionFactory.createGenericPojoDefinition(value, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
        }
        return result;
    }

    private static ObjectFieldDefinition createGenericPojoDefinition(Object value, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        List<Field> fields = ObjectFieldDefinitionFactory.getInheritedPrivateFields(type);
        ArrayList<ObjectFieldDefinition> elements = new ArrayList<ObjectFieldDefinition>();
        ObjectFieldDefinition result = new ObjectFieldDefinition(name, type.getCanonicalName(), ObjectFieldDefinitionFactory.getValue(value), elements, modifiers, path, dwAccessor);
        processed.put(fieldIdentifier, result);
        if (ObjectFieldDefinitionFactory.shouldGoDeeper(depth, maxDepth)) {
            for (Field field : fields) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(value);
                    Class<?> typeClass = fieldValue == null ? field.getType() : fieldValue.getClass();
                    elements.add(ObjectFieldDefinitionFactory.createChildField(fieldValue, typeClass, path, field.getName(), processed, field.getModifiers(), depth, maxDepth, charset, DataWeaveUtils.appendSelector((String)dwAccessor, (String)field.getName())));
                }
                catch (IllegalAccessException e) {
                    logger.error("Error while obtaing fieldValue", (Throwable)e);
                }
            }
        } else {
            result.setHasUnloadedChildren(true);
        }
        return result;
    }

    private static ObjectFieldDefinition createMultiMapDefinition(MultiMap<?, ?> value, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        ArrayList entryList = new ArrayList(value.entryList());
        return ObjectFieldDefinitionFactory.doCreateMapDefinition(value, entryList, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
    }

    private static ObjectFieldDefinition createMapDefinition(Map<?, ?> value, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        ArrayList entryList = new ArrayList(value.entrySet());
        return ObjectFieldDefinitionFactory.doCreateMapDefinition(value, entryList, type, path, name, processed, modifiers, depth, maxDepth, charset, dwAccessor, fieldIdentifier);
    }

    private static ObjectFieldDefinition doCreateMapDefinition(Map<?, ?> value, List<Map.Entry<?, ?>> entries, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        ArrayList<ObjectFieldDefinition> mapElements = new ArrayList<ObjectFieldDefinition>();
        ObjectFieldDefinition result = new ObjectFieldDefinition(name, type.getCanonicalName(), SIZE + entries.size(), mapElements, modifiers, path, dwAccessor);
        processed.put(fieldIdentifier, result);
        if (ObjectFieldDefinitionFactory.shouldGoDeeper(depth, maxDepth)) {
            int i = 0;
            for (Map.Entry<?, ?> entryElement : entries) {
                ArrayList<ObjectFieldDefinition> entryDefinition = new ArrayList<ObjectFieldDefinition>();
                String positionName = ObjectFieldDefinitionFactory.getValue(i);
                Object key = entryElement.getKey();
                String valueDWAccessor = DataWeaveUtils.appendSelector((String)dwAccessor, key, (int)i);
                ObjectFieldDefinition objectFieldDefinition = new ObjectFieldDefinition(positionName, entryElement.getClass().getName(), ObjectFieldDefinitionFactory.getValue(entryElement), entryDefinition, modifiers, result.getPath().addChild(new FieldNode(positionName)), false, valueDWAccessor);
                mapElements.add(objectFieldDefinition);
                Class<?> keyType = key == null ? null : key.getClass();
                entryDefinition.add(ObjectFieldDefinitionFactory.createChildField(key, keyType, objectFieldDefinition.getPath(), KEY_NAME, processed, 0, depth, maxDepth, charset, NULL_DW_ACCESSOR));
                Object valueObject = entryElement.getValue();
                Class<?> valueType = valueObject == null ? null : valueObject.getClass();
                entryDefinition.add(ObjectFieldDefinitionFactory.createChildField(valueObject, valueType, objectFieldDefinition.getPath(), VALUE_NAME, processed, 0, depth, maxDepth, charset, valueDWAccessor));
                ++i;
            }
        } else {
            result.setHasUnloadedChildren(!value.isEmpty());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectFieldDefinition createCursorIteratorProviderDefinition(CursorIteratorProvider value, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        ObjectFieldDefinition result;
        ArrayList<ObjectFieldDefinition> arrayElements = new ArrayList<ObjectFieldDefinition>();
        ObjectFieldDefinition possibleResult = new ObjectFieldDefinition(name, type.getCanonicalName(), "size = Unknown size", arrayElements, modifiers, path, dwAccessor);
        try (CursorIterator cursor = (CursorIterator)value.openCursor();){
            int arrayLength = cursor.getSize();
            possibleResult = new ObjectFieldDefinition(name, type.getCanonicalName(), SIZE + arrayLength, arrayElements, modifiers, path, dwAccessor);
            if (ObjectFieldDefinitionFactory.shouldGoDeeper(depth, maxDepth)) {
                int quantity;
                String arrayClassName = type.getCanonicalName();
                for (quantity = 0; cursor.hasNext() && quantity <= MuleDebuggerProperties.DEFAULT_MAX_ARRAY_PROPERTY; ++quantity) {
                    Object cursorItem = cursor.next();
                    Class<?> arrayElementType = cursorItem == null ? null : cursorItem.getClass();
                    arrayClassName = arrayElementType == null ? arrayClassName : "Array<" + arrayElementType.getCanonicalName() + ">";
                    arrayElements.add(ObjectFieldDefinitionFactory.createChildField(cursorItem, arrayElementType, possibleResult.getPath(), ObjectFieldDefinitionFactory.getValue(quantity), processed, 0, depth, maxDepth, charset, DataWeaveUtils.appendIndex((String)dwAccessor, (int)quantity)));
                }
                if (arrayLength == -1) {
                    possibleResult.setValue(SIZE + quantity);
                    possibleResult.setClassName(arrayClassName);
                }
            } else {
                possibleResult.setHasUnloadedChildren(true);
            }
        }
        catch (Exception e) {
            logger.error("Error while creating the definition from the CursorIterator", (Throwable)e);
        }
        finally {
            result = possibleResult;
            processed.put(fieldIdentifier, result);
        }
        return result;
    }

    private static boolean shouldGoDeeper(int currentDepth, int maxDepth) {
        return currentDepth <= maxDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectFieldDefinition createCursorStreamProviderDefinition(Object value, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        ObjectFieldDefinition result;
        CursorStreamProvider cursorStreamProvider = (CursorStreamProvider)value;
        ObjectFieldDefinition possibleResult = ObjectFieldDefinitionFactory.createSimpleField(value, value.getClass(), name, modifiers, path, dwAccessor);
        try (CursorStream cursor = (CursorStream)cursorStreamProvider.openCursor();
             BoundedInputStream boundedInputStream = new BoundedInputStream((InputStream)cursor, ObjectFieldDefinitionFactory.getMaxStreamSize());){
            String content = IOUtils.toString((InputStream)boundedInputStream, (Charset)charset);
            if ((long)content.getBytes().length == ObjectFieldDefinitionFactory.getMaxStreamSize()) {
                content = PREFIX_PAYLOAD_TOO_LONG + content;
            }
            possibleResult = ObjectFieldDefinitionFactory.createSimpleField(content, value.getClass(), name, modifiers, path, dwAccessor);
        }
        catch (Exception e) {
            logger.error("Error while creating the definition from the CursorStream", (Throwable)e);
        }
        finally {
            result = possibleResult;
            processed.put(fieldIdentifier, result);
        }
        return result;
    }

    private static ObjectFieldDefinition createArrayDefinition(Object value, Class<?> type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, Charset charset, String dwAccessor, FieldIdentifier fieldIdentifier) {
        ArrayList<ObjectFieldDefinition> arrayElements = new ArrayList<ObjectFieldDefinition>();
        int arrayLength = Array.getLength(value);
        ObjectFieldDefinition result = new ObjectFieldDefinition(name, type.getCanonicalName(), SIZE + arrayLength, arrayElements, modifiers, path, dwAccessor);
        processed.put(fieldIdentifier, result);
        if (ObjectFieldDefinitionFactory.shouldGoDeeper(depth, maxDepth)) {
            int length = Math.min(arrayLength, MuleDebuggerProperties.DEFAULT_MAX_ARRAY_PROPERTY);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(value, i);
                Class<?> arrayElementType = arrayElement == null ? null : arrayElement.getClass();
                arrayElements.add(ObjectFieldDefinitionFactory.createChildField(arrayElement, arrayElementType, result.getPath(), ObjectFieldDefinitionFactory.getValue(i), processed, 0, depth, maxDepth, charset, DataWeaveUtils.appendIndex((String)dwAccessor, (int)i)));
            }
        } else {
            result.setHasUnloadedChildren(arrayLength != 0);
        }
        return result;
    }

    private static long getMaxStreamSize() {
        return Long.getLong("mule.debug.max.consume.stream.size", 0x200000L);
    }

    private static ObjectFieldDefinition createCollectionFieldDefinition(Collection value, Class type, FieldPath path, String name, HashMap<FieldIdentifier, ObjectFieldDefinition> processed, int modifiers, int depth, int maxDepth, FieldIdentifier fieldIdentifier, Charset charset, String dwAccessor) {
        ArrayList<ObjectFieldDefinition> arrayElements = new ArrayList<ObjectFieldDefinition>();
        ObjectFieldDefinition result = new ObjectFieldDefinition(name, type.getCanonicalName(), SIZE + value.size(), arrayElements, modifiers, path, dwAccessor);
        processed.put(fieldIdentifier, result);
        if (ObjectFieldDefinitionFactory.shouldGoDeeper(depth, maxDepth)) {
            Object[] array = value.toArray();
            int length = Math.min(array.length, MuleDebuggerProperties.DEFAULT_MAX_ARRAY_PROPERTY);
            for (int i = 0; i < length; ++i) {
                Object iterableElement = array[i];
                Class<?> iterableElementType = iterableElement == null ? null : iterableElement.getClass();
                arrayElements.add(ObjectFieldDefinitionFactory.createChildField(iterableElement, iterableElementType, result.getPath(), ObjectFieldDefinitionFactory.getValue(i), processed, 0, depth, maxDepth, charset, DataWeaveUtils.appendIndex((String)dwAccessor, (int)i)));
            }
        } else {
            result.setHasUnloadedChildren(!value.isEmpty());
        }
        return result;
    }

    public static String getValue(Object value) {
        String result;
        try {
            result = String.valueOf(value);
        }
        catch (Exception e) {
            result = value.getClass().getName() + System.identityHashCode(value);
        }
        return result;
    }

    private static List<Field> getInheritedPrivateFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                result.add(field);
            }
        }
        return result;
    }

    public static ObjectFieldDefinition createSimpleField(Object value, Class clazz, String name, int modifiers, FieldPath path, boolean canEdit, String dwAccessor) {
        String className = clazz != null ? clazz.getCanonicalName() : "";
        return new ObjectFieldDefinition(name, className, ObjectFieldDefinitionFactory.getValue(value), new ArrayList(), modifiers, path, canEdit, dwAccessor);
    }

    private static ObjectFieldDefinition createSimpleField(Object value, Class clazz, String name, int modifiers, FieldPath path, String dwAccessor) {
        String className = clazz != null ? clazz.getCanonicalName() : "";
        return new ObjectFieldDefinition(name, className, ObjectFieldDefinitionFactory.getValue(value), new ArrayList(), modifiers, path, dwAccessor);
    }

    public static ObjectFieldDefinition createFromObject(Object value, String name, String source, Charset charset, String dwAccessor) {
        return ObjectFieldDefinitionFactory.createFromObject(value, name, new FieldPath(source), charset, dwAccessor);
    }

    public static ObjectFieldDefinition createFromObject(Object value, String name, FieldPath source, Charset charset, String dwAccessor) {
        Class<?> valueType = value == null ? null : value.getClass();
        return ObjectFieldDefinitionFactory.createFromObject(value, valueType, name, source, charset, dwAccessor);
    }

    public static ObjectFieldDefinition createFromObject(Object value, Class<?> valueType, String name, FieldPath source, Charset charset, String dwAccessor) {
        return ObjectFieldDefinitionFactory.create(value, valueType, source, name, charset, dwAccessor);
    }

    private static class FieldIdentifier {
        private final Object value;
        private final String name;

        private FieldIdentifier(Object value, String name) {
            this.value = value;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldIdentifier)) {
                return false;
            }
            FieldIdentifier that = (FieldIdentifier)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.value);
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

