/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client.impl;

import com.mulesoft.mule.debugger.client.IDebuggerRequestHandler;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.transport.IServerDebuggerProtocol;

public class ClientCommunicationService {
    private IDebuggerRequestHandler requestHandler;
    private volatile boolean keepRunning = false;
    private final IServerDebuggerProtocol protocol;

    public ClientCommunicationService(IServerDebuggerProtocol protocol) {
        this.protocol = protocol;
    }

    public void start() {
        this.keepRunning = true;
        while (this.keepRunning) {
            IDebuggerRequest request = this.protocol.getRequest();
            if (this.requestHandler == null) continue;
            IDebuggerResponse response = this.requestHandler.handleRequest(request);
            this.protocol.sendResponse(response);
        }
    }

    public void sendEvent(IDebuggerResponse response) {
        this.protocol.sendResponse(response);
    }

    public boolean isRunning() {
        return this.keepRunning;
    }

    public void setRequestHandler(IDebuggerRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void stop() {
        this.keepRunning = false;
    }
}

