/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.IDebuggerRequestHandler;
import com.mulesoft.mule.debugger.command.AddBreakpointCommand;
import com.mulesoft.mule.debugger.command.DefaultCommand;
import com.mulesoft.mule.debugger.command.EnableExceptionBreakpointCommand;
import com.mulesoft.mule.debugger.command.ErrorCommand;
import com.mulesoft.mule.debugger.command.ExecuteScriptCommand;
import com.mulesoft.mule.debugger.command.ExitDebuggerCommand;
import com.mulesoft.mule.debugger.command.ICommand;
import com.mulesoft.mule.debugger.command.LoadInnerFieldsCommand;
import com.mulesoft.mule.debugger.command.NextStepCommand;
import com.mulesoft.mule.debugger.command.RemoveBreakpointCommand;
import com.mulesoft.mule.debugger.command.ResumeCommand;
import com.mulesoft.mule.debugger.command.RunToProcessorCommand;
import com.mulesoft.mule.debugger.command.SchedulerCommand;
import com.mulesoft.mule.debugger.command.UpdateFieldCommand;
import com.mulesoft.mule.debugger.handler.impl.BreakpointHandler;
import com.mulesoft.mule.debugger.mule.deployment.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.request.DebugOperation;
import com.mulesoft.mule.debugger.request.IDebuggerRequest;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.server.IDebuggerManager;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerRequestHandlerImpl
implements IDebuggerRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerRequestHandlerImpl.class);
    private final ComponentLocatorProvider componentLocatorProvider;
    private final IDebuggerManager actionHandler;
    private final IDebuggerClientConnectionHandler clientConnectionHandler;
    private final BreakpointHandler breakpointHandler;
    private static final Map<DebugOperation, ICommand> commands = new EnumMap<DebugOperation, ICommand>(DebugOperation.class);
    private static final ICommand defaultCommand = new DefaultCommand();

    public DebuggerRequestHandlerImpl(IDebuggerManager actionHandler, IDebuggerClientConnectionHandler clientConnectionHandler, BreakpointHandler breakpointHandler, ComponentLocatorProvider componentLocatorProvider) {
        this.actionHandler = actionHandler;
        this.clientConnectionHandler = clientConnectionHandler;
        this.breakpointHandler = breakpointHandler;
        this.componentLocatorProvider = componentLocatorProvider;
    }

    @Override
    public IDebuggerResponse handleRequest(IDebuggerRequest request) {
        IDebuggerResponse response;
        ICommand command = commands.getOrDefault(request.getOperation(), defaultCommand);
        command.setDebuggerManager(this.actionHandler);
        command.setClientConnectionHandler(this.clientConnectionHandler);
        command.setBreakpointHandler(this.breakpointHandler);
        command.setRequest(request);
        command.setComponentLocatorProvider(this.componentLocatorProvider);
        try {
            response = command.execute();
        }
        catch (Exception e) {
            logger.error("Exception while executing command", (Throwable)e);
            response = new ErrorResponse("Unexpected error: '" + e.getMessage() + "' while executing command : '" + command.getClass().getName() + "'");
        }
        response.setRequest(request);
        return response;
    }

    static {
        commands.put(DebugOperation.ADD_BP, new AddBreakpointCommand());
        commands.put(DebugOperation.EXCEPTION_BP, new EnableExceptionBreakpointCommand());
        commands.put(DebugOperation.ERROR, new ErrorCommand());
        commands.put(DebugOperation.EXECUTE_SCRIPT, new ExecuteScriptCommand());
        commands.put(DebugOperation.EXIT, new ExitDebuggerCommand());
        commands.put(DebugOperation.LOAD_INNER_FIELDS, new LoadInnerFieldsCommand());
        commands.put(DebugOperation.NEXT_STEP, new NextStepCommand());
        commands.put(DebugOperation.REMOVE_BP, new RemoveBreakpointCommand());
        commands.put(DebugOperation.RESUME, new ResumeCommand());
        commands.put(DebugOperation.RUN_TO, new RunToProcessorCommand());
        commands.put(DebugOperation.SCHEDULER, new SchedulerCommand());
        commands.put(DebugOperation.UDPATE_FIELDS, new UpdateFieldCommand());
    }
}

