/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.mule.interceptor;

import com.mulesoft.mule.debugger.handler.IMuleNotificationHandler;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.interception.SourceInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerSourceInterceptor
implements SourceInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerSourceInterceptor.class);
    private final IMuleNotificationHandler notificationHandler;

    public DebuggerSourceInterceptor(IMuleNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public void beforeCallback(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        logger.debug("Before source callback-> Path :{} ", (Object)location.getLocation());
        this.notificationHandler.onFlowEnded(() -> ((InterceptionEvent)event).getCorrelationId());
    }

    public void afterCallback(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        logger.debug("After source callback -> Path : {}", (Object)location.getLocation());
        thrown.ifPresent(exception -> this.notificationHandler.onFlowEndedWithException(() -> ((InterceptionEvent)event).getCorrelationId(), (Throwable)exception));
    }
}

