/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.impl.DebuggerEventFactory;
import com.mulesoft.mule.debugger.mule.deployment.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.response.MuleMessageArrivedResponse;
import com.mulesoft.mule.debugger.server.IDebuggerManager;
import com.mulesoft.mule.debugger.server.IEventSender;
import com.mulesoft.mule.debugger.server.IExecutionManager;
import com.mulesoft.mule.debugger.server.impl.MuleDebuggingContext;
import com.mulesoft.mule.debugger.util.ComponentLocationMatcher;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MuleExecutionManager
implements IExecutionManager,
IEventSender {
    private final Object messageProcessed = new Object();
    private final Lock singleMessage = new ReentrantLock(true);
    private String runToProcessor;
    private final IDebuggerClientConnectionHandler clientConnectionHandler;
    private final IDebuggerManager debuggerManager;
    private MuleDebuggingContext muleDebuggingContext;
    private ComponentLocatorProvider locatorProvider;

    public MuleExecutionManager(IDebuggerManager debuggerManager, IDebuggerClientConnectionHandler clientConnectionHandler) {
        this.debuggerManager = debuggerManager;
        this.clientConnectionHandler = clientConnectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        if (this.getDebuggingEvent() != null) {
            this.setRunToProcessor(null);
            this.debuggerManager.setStepping(this.getDebuggingEvent().getInterceptionEvent(), false);
            Object object = this.messageProcessed;
            synchronized (object) {
                this.messageProcessed.notify();
            }
        }
    }

    public MuleDebuggingContext getDebuggingEvent() {
        return this.muleDebuggingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextStep() {
        if (this.getDebuggingEvent() != null) {
            this.debuggerManager.setStepping(this.getDebuggingEvent().getInterceptionEvent(), true);
            Object object = this.messageProcessed;
            synchronized (object) {
                this.messageProcessed.notify();
            }
        }
    }

    @Override
    public void runToLocation(String location) {
        this.setRunToProcessor(location);
        this.nextStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution(MuleDebuggingContext debuggingContext, Throwable exception) {
        if (this.debuggerManager.isDebuggingThisMessage(debuggingContext.getIdProvider())) {
            try {
                this.singleMessage.lock();
                this.muleDebuggingContext = debuggingContext;
                this.debuggerManager.setStepping(debuggingContext.getInterceptionEvent(), null);
                this.sendEvent(DebuggerEventFactory.createExceptionThrownEvent(this.muleDebuggingContext, exception));
                try {
                    Object object = this.messageProcessed;
                    synchronized (object) {
                        this.messageProcessed.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.debuggerManager.stopAllDebuggingSessions();
                }
            }
            finally {
                this.singleMessage.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution(MuleDebuggingContext debuggingContext) {
        block13: {
            if (this.debuggerManager.isDebuggingThisMessage(debuggingContext.getIdProvider())) {
                if (!this.isApplicationRunning(debuggingContext.getAppName())) {
                    this.debuggerManager.stopAllDebuggingSessions();
                    return;
                }
                try {
                    this.singleMessage.lock();
                    if (!this.debuggerManager.isDebuggingThisMessage(debuggingContext.getIdProvider())) break block13;
                    if (this.getRunToProcessor() != null) {
                        boolean matches = ComponentLocationMatcher.matches(debuggingContext.getComponentLocation(), this.getRunToProcessor());
                        if (!matches) {
                            this.debuggerManager.setStepping(debuggingContext.getInterceptionEvent(), true);
                            return;
                        }
                        this.setRunToProcessor(null);
                    }
                    this.muleDebuggingContext = debuggingContext;
                    this.debuggerManager.setStepping(debuggingContext.getInterceptionEvent(), null);
                    this.sendEvent(DebuggerEventFactory.createMessageArrivedEvent(debuggingContext));
                    try {
                        Object matches = this.messageProcessed;
                        synchronized (matches) {
                            this.messageProcessed.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        this.debuggerManager.stopAllDebuggingSessions();
                    }
                }
                finally {
                    this.singleMessage.unlock();
                }
            }
        }
    }

    @Override
    public void sendEvent(MuleMessageArrivedResponse messageArrivedEvent) {
        this.clientConnectionHandler.getClientCommunicationService().sendEvent((IDebuggerResponse)messageArrivedEvent);
    }

    private boolean isApplicationRunning(String appName) {
        return this.locatorProvider.getLocator(appName) != null;
    }

    public void setLocatorProvider(ComponentLocatorProvider locatorProvider) {
        this.locatorProvider = locatorProvider;
    }

    private String getRunToProcessor() {
        return this.runToProcessor;
    }

    private void setRunToProcessor(String runToProcessor) {
        this.runToProcessor = runToProcessor;
    }
}

